package parser;

/**
 * Multiply token class.
 */
public class MultToken extends AToken {
    /**
     * Interface for a visitor to visit a multiply token.
     */
    public static interface IMultVisitor extends ITokVisitor {
        /**
         * Case for a mult token.
         *
         * @param host  mult token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object multCase(MultToken host, Object param);
    }

    /**
     * Singleton instance.
     */
    public final static MultToken Singleton = new MultToken();

    /**
     * Private singleton constructor.
     */
    private MultToken() {
        super("*");
    }

    /**
     * Execute the mult case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public Object execute(ITokVisitor algo, Object param) {
        return (algo instanceof IMultVisitor) ?
               ((IMultVisitor) algo).multCase(this, param) :
               algo.defaultCase(this, param);
    }
}

